<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('karpet', function (Blueprint $table) {
            $table->id();
             $table->string('nama');
            $table->string('kategori');
            $table->string('ketebalan');
            $table->integer('stok_per_meter');
            $table->integer('minimum_stok_per_meter')->default(10); // untuk notifikasi stok menipis
            $table->integer('stok_per_roll');
            $table->integer('minimum_stok_per_roll')->default(10); // untuk notifikasi stok menipis
            $table->integer('harga_per_meter');
            $table->string('foto')->nullable();
            $table->text('deskripsi')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('karpet');
    }
};
